<?php
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Set session timeout to 15 minutes (900 seconds)
$timeout = 15 * 60; // 15 minutes in seconds

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    // Try to determine the correct path
    if (file_exists('../auth/login.php')) {
    header('Location: ../auth/login.php');
    } else {
        header('Location: auth/login.php');
    }
    exit;
}

// Check for session timeout
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
    // Unset all session variables
    $_SESSION = array();
    // Destroy the session
    session_destroy();
    // Redirect to login page
    if (file_exists('../auth/login.php')) {
        header('Location: ../auth/login.php?timeout=1');
    } else {
        header('Location: auth/login.php?timeout=1');
    }
    exit;
}

// Update last activity time stamp
$_SESSION['last_activity'] = time();

// Include auth functions - try different paths
if (file_exists('../auth/auth.php')) {
require_once '../auth/auth.php';
} elseif (file_exists('auth/auth.php')) {
    require_once 'auth/auth.php';
} else {
    // Try to find it relative to current file
    $authPath = dirname(__FILE__) . '/../auth/auth.php';
    if (file_exists($authPath)) {
        require_once $authPath;
    } else {
        die('Could not find auth.php file');
    }
}

// Note: Individual pages should handle their own permission requirements
// This file only ensures the user is logged in
?> 